﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Product
{
    public partial class EditProduct : System.Web.UI.Page
    {
        private Entities.Products myProduct;
        private static Guid CurSharingInventoryID;
        private static List<Entities.ProductMeasurement> SizeList;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                CurSharingInventoryID = Guid.Empty;
                FillListItems();
                if (Request.QueryString["UniqueID"] != null)
                {
                    WebSession.ProductsXMeasurementList = null;
                    hdProductID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductDetails();
                    WebSession.ProductsXMeasurementList = ProductsXMeasurementBL.GetList(Guid.Empty, Guid.Parse(hdProductID.Value)).ToList<ProductsXMeasurements>();
                    LoadTargetSizes();
                }
                else
                {
                    List<Entities.Products> Products = ProductsBL.GetList(Guid.Empty, string.Empty);
                    if(Products!=null && Products.Count>0)
                    {
                        Products = Products.Where(a=>a.IsActive).ToList<Entities.Products>();
                    }
                    if(Products!=null)
                    {
                        txtSequenceNo.Text = (Products.Max(a => a.SequenceNo) + 1).ToString();
                    }
                }
            }
        }

        private void LoadTargetSizes()
        {
            if (!(string.IsNullOrEmpty(hdProductID.Value)))
            {
                List<ProductsXMeasurements> ProductSizes = new List<ProductsXMeasurements>();
                //There are already sizes associated with this product
                if (WebSession.ProductsXMeasurementList != null && WebSession.ProductsXMeasurementList.Count > 0)
                {
                    ProductSizes = WebSession.ProductsXMeasurementList.Where(a => a.IsActive).ToList<ProductsXMeasurements>();
                    if (ProductSizes != null && ProductSizes.Count > 0)
                    {
                        gvSizes.DataSource = ProductSizes;
                        gvSizes.DataBind();
                    }
                    else
                    {
                        gvSizes.DataSource = ProductSizes;
                        gvSizes.DataBind();
                    }
                }
                else
                {
                    WebSession.ProductsXMeasurementList = ProductSizes;
                    gvSizes.DataSource = ProductSizes;
                    gvSizes.DataBind();
                }
            }
        }

        private void FillListItems()
        {
            List<Entities.Products> ProductList = ProductsBL.GetList(Guid.Empty, string.Empty);
            if (ProductList != null && ProductList.Count > 0)
            {
                ProductList = ProductList.Where(a => a.IsActive).ToList<Entities.Products>();
            }

            SizeList = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
            if (SizeList != null && SizeList.Count > 0)
            {
                SizeList = SizeList.Where(a => a.IsActive).ToList<Entities.ProductMeasurement>();
            }

            List<Entities.ProductCategory> CategoryList = ProductCategoryBL.GetList(Guid.Empty, string.Empty);
            if (CategoryList != null && CategoryList.Count > 0)
            {
                CategoryList = CategoryList.Where(a => a.IsActive).ToList<Entities.ProductCategory>();
            }

            List<Entities.ProductBrand> BrandList = ProductBrandBL.GetList(Guid.Empty, string.Empty);
            if (BrandList != null && BrandList.Count > 0)
            {
                BrandList = BrandList.Where(a => a.IsActive).ToList<Entities.ProductBrand>();
            }

            WebUtilities.FillDropDownList(ddlCategory, CategoryList, "UniqueID", "CategoryName");
            //WebUtilities.FillCheckBoxList(cbListCategory, CategoryList, "UniqueID", "CategoryName");
            WebUtilities.FillDropDownList(ddlBrand, BrandList, "UniqueID", "BrandName");
            // WebUtilities.FillDropDownList(ddlColor, ProductColorBL.GetDataTable(Guid.Empty, string.Empty), "ProductColorID", "ColorName");
            WebUtilities.FillDropDownList(ddlSize, SizeList, "UniqueID", "MeasurementName");
            WebUtilities.FillDropDownList(ddlTargetSize, SizeList, "UniqueID", "MeasurementName");
            var DropdownList = from product in ProductList
                               join size in SizeList on product.ProductMeasurementID equals size.UniqueID
                               select new { ProductsID = product.UniqueID, ProductName = string.Format("{0}({1})", product.ProductName, size.MeasurementName) };

            ddlShareInventory.Items.Add(new ListItem("Select", "0"));
            DropdownList.ToList().ForEach(a => ddlShareInventory.Items.Add(new ListItem(a.ProductName, a.ProductsID.ToString())));


            //WebUtilities.FillDropDownList(ddlShareInventory, DropdownList, "ProductsID", "ProductName");
            imgDelete1.Visible = false;
        }

        private void FillProductSubCategory()
        {

        }

        private void ShowProductDetails()
        {
            myProduct = ProductsBL.GetItem(Guid.Parse(hdProductID.Value.Trim()), string.Empty);
            if (myProduct != null)
            {

                hdProductID.Value = myProduct.UniqueID.ToString();
                txtProductName.Text = myProduct.ProductName;
                ddlCategory.SelectedIndex = ddlCategory.Items.IndexOf(ddlCategory.Items.FindByValue(myProduct.ProductCategoryID.ToString()));
                //foreach (ProductsXCategory pXC in myProduct.ProductsXCategoryList)
                //{
                //    foreach (ListItem item in cbListCategory.Items)
                //    {
                //        if (Guid.Parse(item.Value).Equals(pXC.ProductCategoryID))
                //            item.Selected = true;
                //    }
                //}
                FillProductSubCategory();
                ddlBrand.SelectedIndex = ddlBrand.Items.IndexOf(ddlBrand.Items.FindByValue(myProduct.ProductBrandID.ToString()));
                ddlSize.SelectedIndex = ddlSize.Items.IndexOf(ddlSize.Items.FindByValue(myProduct.ProductMeasurementID.ToString()));
                txtProductCode.Text = myProduct.ProductCode;
                txtUnitPrice.Text = myProduct.UnitPrice.ToString("0.00");
                chkShowPrice.Checked = myProduct.ShowProductPrice;
                txtActualStock.Text = myProduct.ActualStock.ToString();
                txtReserveStock.Text = myProduct.ReserveStock.ToString();
                txtLowStockIndication.Text = myProduct.LowStockIndication.ToString();
                txtHappyHourPrice.Text = myProduct.HappyHourPrice.ToString("0.00");
                hdImage1.Value = string.IsNullOrEmpty(myProduct.Image1) ? string.Empty : myProduct.Image1;
                lnkImage1.Attributes.Add("onclick", "divProductPreview('" + "../../../Images/ProductsImages/" + myProduct.Image1 + "')");

                imgDelete1.Visible = lnkImage1.Visible = !string.IsNullOrEmpty(myProduct.Image1);
                chkIsSale.Checked = myProduct.IsSales;
                chkIsActive.Checked = myProduct.IsActive;
                if (myProduct.ShareInventoryID != null && myProduct.ShareInventoryID != Guid.Empty)
                {
                    ddlShareInventory.Items.FindByValue(myProduct.ShareInventoryID.ToString()).Selected = true;
                    CurSharingInventoryID = myProduct.ShareInventoryID;
                }

            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                myProduct = new Entities.Products();
                if (hdProductID.Value.Trim().Length == 0)
                    myProduct.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    myProduct.Mode = GlobalConfigurations.Mode.Update;
                    myProduct.UniqueID = Guid.Parse(hdProductID.Value.Trim());
                }

                myProduct.ProductName = txtProductName.Text.Trim();
                myProduct.ProductCategoryID = Guid.Parse(ddlCategory.SelectedValue);
                //foreach (ListItem item in cbListCategory.Items)
                //{
                //    if (item.Selected)
                //    {
                //        myProduct.ProductsXCategoryList.Add(new ProductsXCategory { ProductCategoryID = Guid.Parse(item.Value) });
                //    }
                //}
                myProduct.ProductBrandID = ((ddlBrand.SelectedValue != null && ddlBrand.SelectedValue != "0") ? Guid.Parse(ddlBrand.SelectedValue) : Guid.Empty);
                myProduct.ProductColorID = Guid.Empty;
                myProduct.ProductMeasurementID = ((ddlSize.SelectedValue != null && ddlSize.SelectedValue != "0") ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty);

                myProduct.ProductHeight = 0.00M;
                myProduct.ProductDepth = 0.00M;
                myProduct.ProductWidth = 0.00M;
                myProduct.ProductWeight = 0.00M;

                myProduct.ProductCode = txtProductCode.Text.Trim();
                myProduct.UnitPrice = decimal.Parse(txtUnitPrice.Text.Trim());
                myProduct.ShowProductPrice = chkShowPrice.Checked;
                if (chkIsSale.Checked)
                {
                    myProduct.ActualStock = int.Parse(txtActualStock.Text.Trim());
                    myProduct.ReserveStock = int.Parse(txtReserveStock.Text.Trim());
                    myProduct.LowStockIndication = int.Parse(txtLowStockIndication.Text.Trim());
                }
                myProduct.EarliestAvailableDays = 0;
                myProduct.ProductWarrenty = 0;
                myProduct.ProductDescriptions = string.Empty;
                myProduct.ProductDescriptionsForQuote = string.Empty;
                myProduct.DesignerInfo = string.Empty;
                myProduct.AdditionalInfo = string.Empty;
                myProduct.Image1 = hdImage1.Value.Trim();
                myProduct.Image2 = string.Empty;
                myProduct.Image3 = string.Empty;
                myProduct.Image4 = string.Empty;
                myProduct.Image5 = string.Empty;

                imgDelete1.Visible = lnkImage1.Visible = !string.IsNullOrEmpty(myProduct.Image1);

                string docName, rootPath, fullName;
                docName = rootPath = fullName = string.Empty;

                myProduct.AdditionalInfo = string.Empty;

                if (fileImage1.HasFile)
                {
                    docName = fileImage1.FileName;
                    rootPath = Server.MapPath("~/Images/ProductsImages/");
                    fullName = WebUtilities.CreateFileWithUniqueName(rootPath, docName);
                    myProduct.Image1 = System.IO.Path.GetFileName(fullName);

                    fileImage1.SaveAs(fullName);
                }
                myProduct.AccessoriesType = string.Empty;

                myProduct.IsBestSales = false;
                myProduct.IsNew = false;
                myProduct.IsSales = chkIsSale.Checked;
                myProduct.IsMiscellaneous = false;
                myProduct.IsARProduct = false;
                myProduct.HappyHourPrice = string.IsNullOrEmpty(txtHappyHourPrice.Text.Trim()) ? 0.00M : decimal.Parse(txtHappyHourPrice.Text.Trim());
                myProduct.IsActive = chkIsActive.Checked;
                myProduct.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if ((!string.IsNullOrEmpty(ddlShareInventory.SelectedValue)) && ddlShareInventory.SelectedValue != "0")
                {
                    Guid ShareINventoryProduct = Guid.Parse(ddlShareInventory.SelectedValue);
                    myProduct.ShareInventoryID = ShareINventoryProduct;
                }
                else
                    myProduct.ShareInventoryID = Guid.Empty;

                if (WebSession.ProductsXMeasurementList != null && WebSession.ProductsXMeasurementList.Count > 0 && (!(string.IsNullOrEmpty(hdProductID.Value))))
                {
                    List<ProductsXMeasurements> CurrentSizes = ProductsXMeasurementBL.GetList(Guid.Empty, Guid.Parse(hdProductID.Value));
                    //If Items already exist for this product
                    if (CurrentSizes != null && CurrentSizes.Count > 0)
                    {
                        CurrentSizes = CurrentSizes.Where(a => a.IsActive).ToList<ProductsXMeasurements>();
                        //Get the Deleted Items from local list.
                        List<ProductsXMeasurements> DeletedItems = WebSession.ProductsXMeasurementList.Where(a => a.IsActive == false).ToList<ProductsXMeasurements>();
                        if (DeletedItems != null && DeletedItems.Count > 0 && CurrentSizes != null)
                        {
                            for (int i = 0; i < DeletedItems.Count; i++)
                            {
                                if (!CurrentSizes.Where(a => a.ProductsXMeasurementID == DeletedItems[i].ProductsXMeasurementID).Any())
                                {
                                    WebSession.ProductsXMeasurementList.RemoveAt(i);

                                }
                            }
                        }
                    }
                }
                myProduct.ProductMeasurementList = WebSession.ProductsXMeasurementList;


                if (ProductsBL.Save(myProduct))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product details has been saved successfully.<br>Do you want to add another Product?", this.ResolveClientUrl("~/Admin/Masters/Product/Products.aspx"));
                    //If the sharing Product is changed, Then revert the old shared product to not sharing
                    if (myProduct.ShareInventoryID != CurSharingInventoryID)
                    {
                        Entities.Products CurProduct = ProductsBL.GetItem(CurSharingInventoryID, string.Empty);
                        CurProduct.ShareInventoryID = Guid.Empty;
                        ProductsBL.Save(CurProduct);
                    }
                    //Add new Product's Sharing inventory to current product
                    if ((!string.IsNullOrEmpty(ddlShareInventory.SelectedValue)) && ddlShareInventory.SelectedValue != "0")
                    {
                        Guid ShareINventoryProduct = Guid.Parse(ddlShareInventory.SelectedValue);
                        Entities.Products CurProduct = ProductsBL.GetItem(ShareINventoryProduct, string.Empty);
                        CurProduct.ShareInventoryID = myProduct.UniqueID;
                        CurProduct.ActualStock = myProduct.ActualStock;
                        CurProduct.ReserveStock = myProduct.ReserveStock;
                        ProductsBL.Save(CurProduct);
                    }
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/Product/Products.aspx", false);
        }

        private bool ValidatePageValue()
        {
            bool validated = true;
            if (!ValidationUtility.ValidateString(txtProductName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtProductName.ClientID + "', 'Please enter valid Product Name.'); ", true);
                validated = false;
            }

            if (ddlCategory.SelectedValue.Equals("0"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlCategory.ClientID + "', 'Please select Product Category.'); ", true);
                validated = false;
            }

            if (ddlBrand.SelectedValue.Equals("0"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlBrand.ClientID + "', 'Please select Product Brand.'); ", true);
                validated = false;
            }

            if (!string.IsNullOrEmpty(txtHappyHourPrice.Text))
            {
                if (!ValidationUtility.ValidateDecimal(txtHappyHourPrice.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtHappyHourPrice.ClientID + "', 'Please enter a valid Happy Hour price.'); ", true);
                    validated = false;
                }
            }

            if (!ValidationUtility.ValidateDecimal(txtUnitPrice.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtUnitPrice.ClientID + "', 'Please enter valid Unit Price.'); ", true);
                validated = false;
            }

            if (chkIsSale.Checked)
            {
                if (!ValidationUtility.ValidateInt(txtActualStock.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtActualStock.ClientID + "', 'Please enter valid Actual Stock.'); ", true);
                    validated = false;
                }

                if (!ValidationUtility.ValidateInt(txtReserveStock.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtReserveStock.ClientID + "', 'Please enter valid Reserve Stock.'); ", true);
                    validated = false;
                }

                if (!ValidationUtility.ValidateInt(txtLowStockIndication.Text.Trim()))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtLowStockIndication.ClientID + "', 'Please enter valid Low Stock Indication.'); ", true);
                    validated = false;
                }
            }


            if (!fileImage1.HasFile && hdImage1.Value.Trim().Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + fileImage1.ClientID + "', 'Please select Product Image 1.'); ", true);
                validated = false;
            }

            if (fileImage1.HasFile)
            {
                if (!ValidationUtility.IsValidImageFile(fileImage1.FileName))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + fileImage1.ClientID + "', 'Please select valid Product Image 1.'); ", true);
                    validated = false;

                }
            }

            if (ddlShareInventory.SelectedValue != null && ddlShareInventory.SelectedValue != "0")
            {
                if (hdProductID.Value.Equals(ddlShareInventory.SelectedValue))
                {
                    ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + ddlShareInventory.ClientID + "', 'You cannot select the same product to share the inventory with. Please change the value before saving.'); ", true);
                    validated = false;
                }
            }

            if (WebSession.ProductsXMeasurementList.Where(a => a.TargetSizeID.ToString().Equals(hdImage1.Value) && a.IsActive).Any())
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#btnAddSizeOpen', 'Target Size cannot contain the source size. Please remove the source size'); ", true);
                validated = false;
            }

            if (WebSession.ProductsXMeasurementList.Where(a => (a.TargetConversion <= 0) && a.IsActive).Any())
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#btnAddSizeOpen', 'Target Size should be greater than 0'); ", true);
                validated = false;
            }


            return validated;
        }

        protected void ddlCategory_SelectedIndexChanged(object sender, EventArgs e)
        {
            FillProductSubCategory();
        }


        protected void btnAddSize_Click(object sender, EventArgs e)
        {
            
            if (ddlTargetSize.SelectedValue != null && ddlTargetSize.SelectedValue != "0" && (!string.IsNullOrEmpty(txtTargetSizeQty.Text)) && (ValidationUtility.ValidateInt(txtTargetSizeQty.Text)))
            {
                ProductsXMeasurements newSize = new ProductsXMeasurements();
                newSize.IsActive = true;
                newSize.BaseSizeID = ddlSize.SelectedValue != null && ddlSize.SelectedValue != "0" ? Guid.Parse(ddlSize.SelectedValue) : Guid.Empty;
                newSize.TargetSizeName = ddlTargetSize.SelectedItem.Text;
                newSize.TargetConversion = int.Parse(txtTargetSizeQty.Text);
                newSize.CreatedBy = WebSession.CurrentAdminUser.UniqueID;
                newSize.TargetSizeID = Guid.Parse(ddlTargetSize.SelectedValue);
                if(!WebSession.ProductsXMeasurementList.Where(a=>a.TargetSizeID== newSize.TargetSizeID).Any())
                WebSession.ProductsXMeasurementList.Add(newSize);
                LoadTargetSizes();
            }
            else
            {
                //Show Error Message
                
            }

            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "OpenSizes();", true);
        }

        protected void gvSizes_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gvSizes.EditIndex = -1;
            LoadTargetSizes();

            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "OpenSizes();", true);
        }

        protected void gvSizes_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gvSizes.EditIndex = e.NewEditIndex;
            LoadTargetSizes();

            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "OpenSizes();", true);
        }

        //protected void gvSizes_RowUpdating(object sender, GridViewUpdateEventArgs e)
        //{
        //    Guid ProductsXSizeID = Guid.Parse(gvSizes.DataKeys[e.RowIndex].Value.ToString());
        //    GridViewRow row = (GridViewRow)gvSizes.Rows[e.RowIndex];
        //    DropDownList TargetSize = (DropDownList)row.Cells[1].FindControl("ddlTargetSizegrid");
        //    TextBox txtTargetQty = (TextBox)row.Cells[2].FindControl("txtTargetQty");

        //    if (!(TargetSize != null && TargetSize.SelectedValue != null && TargetSize.SelectedValue != "0"))
        //    {
        //        return;
        //    }
        //    if (string.IsNullOrEmpty(txtTargetQty.Text))
        //    {
        //        return;
        //    }
        //    else if (!ValidationUtility.ValidateInt(txtTargetQty.Text))
        //    {
        //        return;
        //    }

        //    //if (txtNameEdit, txtCapacity))
        //    //{
        //    ProductsXMeasurements newSizes = new ProductsXMeasurements();
        //    newSizes.ProductsXMeasurementID = ProductsXSizeID;
        //    newSizes.CreatedBy = WebSession.CurrentAdminUser.UniqueID;
        //    newSizes.IsActive = true;
        //    newSizes.TargetConversion = int.Parse(txtTargetQty.Text);
        //    newSizes.TargetSizeID = Guid.Parse(TargetSize.SelectedValue);
        //    newSizes.TargetSizeName = TargetSize.SelectedItem.Text;
        //    WebSession.ProductsXMeasurementList.Remove(WebSession.ProductsXMeasurementList.Where(a => a.ProductsXMeasurementID == newSizes.ProductsXMeasurementID).Single());
        //    WebSession.ProductsXMeasurementList.Add(newSizes);
        //    gvSizes.EditIndex = -1;
        //    LoadTargetSizes();
        //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "OpenSizes();", true);
        //    //}
        //}

        protected void gvSizes_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            Guid TableID = Guid.Parse(gvSizes.DataKeys[e.RowIndex].Value.ToString());
            btnDeleteSize.Attributes["data-TaxID"] = TableID.ToString();
            LoadTargetSizes();
            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "ConfirmDeleteSize();", true);

        }

        protected void btnDeleteSize_Click(object sender, EventArgs e)
        {
            if (WebSession.ProductsXMeasurementList.Where(a => a.ProductsXMeasurementID == Guid.Empty).Count()>1)
            {
                WebUtilities.ShowMessage(this, "Save the product before removing another size.");
                return;
            }
            Guid SizeDelete = Guid.Parse(btnDeleteSize.Attributes["data-TaxID"].ToString());
            ProductsXMeasurements ItemToDelete = WebSession.ProductsXMeasurementList.Where(a => a.ProductsXMeasurementID == SizeDelete).Single();
            if (ItemToDelete.ProductsXMeasurementID != Guid.Empty)
                WebSession.ProductsXMeasurementList.Where(a => a.ProductsXMeasurementID == SizeDelete).Single().IsActive = false;
            else
                WebSession.ProductsXMeasurementList.Remove(WebSession.ProductsXMeasurementList.Where(a => a.ProductsXMeasurementID == SizeDelete).Single());
            LoadTargetSizes();
            ScriptManager.RegisterStartupScript(this, GetType(), "Ei8htPOS", "OpenSizes();", true);

        }

        protected void gvSizes_RowDataBound1(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                DropDownList SizeDDL = e.Row.Cells[1].FindControl("ddlTargetSizegrid") as DropDownList;
                if (SizeDDL != null)
                {
                    SizeDDL.DataTextField = "MeasurementName";
                    SizeDDL.DataValueField = "UniqueID";
                    SizeDDL.DataSource = SizeList;
                    SizeDDL.DataBind();
                }
            }
        }
    }
}